package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;

import java.awt.BorderLayout;

import javax.swing.JButton;
import javax.swing.SwingConstants;
import javax.swing.JLabel;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Font;
import java.awt.Color;

import javax.swing.JSplitPane;
import javax.swing.JScrollPane;
import javax.swing.ImageIcon;

import music.Song;
import net.miginfocom.swing.MigLayout;

import javax.swing.JTextArea;
import javax.swing.JComboBox;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MainAppWindow {

	private JFrame frmLikeARolling;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel southPanel;
	private JPanel eastPanel;
	private JButton btnStart;
	private JLabel lblLegendarySongs;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JLabel label;
	private JLabel lblYear;
	private JLabel lblYearValue;
	private JButton btnSave;
	private JTextArea textArea;
	private JLabel lblSong;
	private JComboBox songComboBox;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnPhoto;
	private JRadioButton rdbtnAll;
	private JLabel lblDetails;
	private final ButtonGroup buttonGroup = new ButtonGroup();

	private NewDialog newDialog = null;
	private Song song;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JMenuItem mntmNew;
	private JMenuItem mntmOpen;
	private JMenuItem mntmSave;
	private JMenuItem mntmExit;
	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmLikeARolling.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmLikeARolling = new JFrame();
		frmLikeARolling.setTitle("Like a Rolling Stone");
		frmLikeARolling.setBounds(100, 100, 450, 300);
		frmLikeARolling.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmLikeARolling.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmLikeARolling.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmLikeARolling.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmLikeARolling.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmLikeARolling.getContentPane().add(getSplitPane_1(), BorderLayout.CENTER);
		frmLikeARolling.setJMenuBar(getMenuBar());
	}

	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.add(getLblLegendarySongs());
			northPanel.add(getBtnStart());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setPreferredSize(new Dimension(100, 10));
			westPanel.setLayout(new MigLayout("", "[grow]", "[][]"));
			westPanel.add(getLblSong(), "cell 0 0");
			westPanel.add(getSongComboBox(), "cell 0 1,growx");
			westPanel.setVisible(false);
		}
		return westPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblDetails(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnPhoto(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
			southPanel.setVisible(false);
		}
		return southPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setLayout(new MigLayout("", "[]", "[][][grow][]"));
			eastPanel.add(getLblYear(), "cell 0 0");
			eastPanel.add(getLblYearValue(), "cell 0 1");
			eastPanel.add(getBtnSave(), "cell 0 3");
			eastPanel.setVisible(false);
		}
		return eastPanel;
	}
	private JButton getBtnStart() {
		if (btnStart == null) {
			btnStart = new JButton("Start");
			btnStart.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					lblLegendarySongs.setVisible(true);
					btnStart.setVisible(false);
//					centerPanel.setVisible(true);
					eastPanel.setVisible(true);
					westPanel.setVisible(true);
					southPanel.setVisible(true);
					splitPane.setVisible(true);
				}
			});
		}
		return btnStart;
	}
	private JLabel getLblLegendarySongs() {
		if (lblLegendarySongs == null) {
			lblLegendarySongs = new JLabel("Legendary songs");
			lblLegendarySongs.setForeground(new Color(0, 0, 255));
			lblLegendarySongs.setFont(new Font("Tahoma", Font.BOLD, 13));
			lblLegendarySongs.setVisible(false);
		}
		return lblLegendarySongs;
	}
	private JSplitPane getSplitPane_1() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setVisible(false);
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getScrollPane_1());
			splitPane.setDividerLocation(100);
			splitPane.setOneTouchExpandable(true);
			splitPane.setDividerSize(8);
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLabel());
		}
		return leftScrollPane;
	}
	private JScrollPane getScrollPane_1() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getTextArea());
		}
		return rightScrollPane;
	}
	private JLabel getLabel() {
		if (label == null) {
			label = new JLabel("");
			label.setIcon(new ImageIcon("C:\\Documents and Settings\\Korisnik\\My Documents\\Like a Rolling Stone, 18.12.2015, 16-18\\resources\\Bob Dylan.jpg"));
		}
		return label;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblYearValue() {
		if (lblYearValue == null) {
			lblYearValue = new JLabel("");
		}
		return lblYearValue;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
		}
		return btnSave;
	}
	private JTextArea getTextArea() {
		if (textArea == null) {
			textArea = new JTextArea();
			textArea.setWrapStyleWord(true);
			textArea.setLineWrap(true);
		}
		return textArea;
	}
	private JLabel getLblSong() {
		if (lblSong == null) {
			lblSong = new JLabel("Song");
		}
		return lblSong;
	}
	private JComboBox getSongComboBox() {
		if (songComboBox == null) {
			songComboBox = new JComboBox();
		}
		return songComboBox;
	}
	private JRadioButton getRdbtnBasic() {
		if (rdbtnBasic == null) {
			rdbtnBasic = new JRadioButton("Basic");
			rdbtnBasic.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					getWestPanel().setVisible(true);
					getSplitPane_1().setVisible(false);
					getEastPanel().setVisible(false);
				}
			});
			buttonGroup.add(rdbtnBasic);
		}
		return rdbtnBasic;
	}
	private JRadioButton getRdbtnPhoto() {
		if (rdbtnPhoto == null) {
			rdbtnPhoto = new JRadioButton("Photo");
			rdbtnPhoto.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					getWestPanel().setVisible(true);
					getSplitPane_1().setVisible(true);
					getEastPanel().setVisible(false);
				}
			});
			buttonGroup.add(rdbtnPhoto);
			rdbtnPhoto.setSelected(true);
		}
		return rdbtnPhoto;
	}
	private JRadioButton getRdbtnAll() {
		if (rdbtnAll == null) {
			rdbtnAll = new JRadioButton("All");
			rdbtnAll.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					getWestPanel().setVisible(true);
					getSplitPane_1().setVisible(true);
					getEastPanel().setVisible(true);
				}
			});
			buttonGroup.add(rdbtnAll);
		}
		return rdbtnAll;
	}
	private JLabel getLblDetails() {
		if (lblDetails == null) {
			lblDetails = new JLabel("Details");
		}
		return lblDetails;
	}
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
			mnFile.add(getMntmNew());
			mnFile.add(getMntmOpen());
			mnFile.add(getMntmSave());
			mnFile.addSeparator();
			mnFile.add(getMntmExit());
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JMenuItem getMntmNew() {
		if (mntmNew == null) {
			mntmNew = new JMenuItem("New...");
			mntmNew.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					newDialog = new NewDialog(frmLikeARolling, true);
					song = newDialog.showDialog();
				}
			});
		}
		return mntmNew;
	}
	private JMenuItem getMntmOpen() {
		if (mntmOpen == null) {
			mntmOpen = new JMenuItem("Open...");
		}
		return mntmOpen;
	}
	private JMenuItem getMntmSave() {
		if (mntmSave == null) {
			mntmSave = new JMenuItem("Save...");
		}
		return mntmSave;
	}
	private JMenuItem getMntmExit() {
		if (mntmExit == null) {
			mntmExit = new JMenuItem("Exit");
		}
		return mntmExit;
	}
}
